import  BaseTool  from './BaseTool.mjs';
import  { redoKeyboardShortcutId, undoKeyboardShortcutId }  from './keybindings.mjs';
// Handles ctrl+Z, ctrl+Shift+Z keyboard shortcuts.
export default class UndoRedoShortcut extends BaseTool {
    constructor(editor) {
        super(editor.notifier, editor.localization.undoRedoTool);
        this.editor = editor;
    }
    // @internal
    onKeyPress(event) {
        if (this.editor.shortcuts.matchesShortcut(undoKeyboardShortcutId, event)) {
            void this.editor.history.undo();
            return true;
        }
        else if (this.editor.shortcuts.matchesShortcut(redoKeyboardShortcutId, event)) {
            void this.editor.history.redo();
            return true;
        }
        return false;
    }
}
