// Allows the toolbar to register keyboard events.
// @packageDocumentation
import  BaseTool  from './BaseTool.mjs';
export default class ToolbarShortcutHandler extends BaseTool {
    constructor(editor) {
        super(editor.notifier, editor.localization.changeTool);
        this.listeners = new Set([]);
    }
    registerListener(listener) {
        this.listeners.add(listener);
    }
    removeListener(listener) {
        this.listeners.delete(listener);
    }
    onKeyPress(event) {
        // TypeScript seems to automatically convert for of loops into for(init;check;update)
        // loops (even with target set to es6). Thus, we cannot iterate directly through the
        // set here.
        // See https://stackoverflow.com/q/48886500
        const listeners = Array.from(this.listeners.values());
        for (const listener of listeners) {
            if (listener(event)) {
                return true;
            }
        }
        return false;
    }
}
