import Editor from '../Editor';
import { KeyPressEvent } from '../inputEvents';
import BaseTool from './BaseTool';
/**
 * Handles keyboard events used, by default, to select tools. By default,
 * 1 maps to the first primary tool, 2 to the second primary tool, ... .
 *
 * This is in the default set of {@link ToolController} tools.
 *
 */
export default class ToolSwitcherShortcut extends BaseTool {
    private editor;
    constructor(editor: Editor);
    canReceiveInputInReadOnlyEditor(): boolean;
    onKeyPress({ key }: KeyPressEvent): boolean;
}
