import Editor from '../Editor';
import BaseTool from './BaseTool';
import ToolEnabledGroup from './ToolEnabledGroup';
import { ToolLocalization } from './localization';
import InputMapper, { InputEventListener } from './InputFilter/InputMapper';
import { InputEvt } from '../inputEvents';
export default class ToolController implements InputEventListener {
    private tools;
    private activeTool;
    private primaryToolGroup;
    private inputPipeline;
    private isEditorReadOnly;
    /** @internal */
    constructor(editor: Editor, localization: ToolLocalization);
    /**
     * Replaces the current set of tools with `tools`. This should only be done before
     * the creation of the app's toolbar (if using `AbstractToolbar`).
     *
     * If no `primaryToolGroup` is given, an empty one will be created.
     */
    setTools(tools: BaseTool[], primaryToolGroup?: ToolEnabledGroup): void;
    /**
     * Add a tool that acts like one of the primary tools (only one primary tool can be enabled at a time).
     *
     * If the tool is already added to this, the tool is converted to a primary tool.
     *
     * This should be called before creating the app's toolbar.
     */
    addPrimaryTool(tool: BaseTool): void;
    getPrimaryTools(): BaseTool[];
    /**
     * Add a tool to the end of this' tool list (the added tool receives events after tools already added to this).
     * This should be called before creating the app's toolbar.
     *
     * If `options.addToFront`, the tool is added to the beginning of this' tool list.
     *
     * Does nothing if the tool is already present.
     */
    addTool(tool: BaseTool, options?: {
        addToFront: boolean;
    }): void;
    /**
     * Removes **and destroys** all tools in `tools` from this.
     */
    removeAndDestroyTools(tools: BaseTool[]): void;
    private insertTools;
    /**
     * Removes a tool from this' tool list and replaces it with `replaceWith`.
     *
     * If any of `toolsToInsert` have already been added to this, the tools are
     * moved.
     *
     * This should be called before creating the editor's toolbar.
     */
    insertToolsAfter(insertAfter: BaseTool, toolsToInsert: BaseTool[]): void;
    /** @see {@link insertToolsAfter} */
    insertToolsBefore(insertBefore: BaseTool, toolsToInsert: BaseTool[]): void;
    private onEventInternal;
    /** Alias for {@link dispatchInputEvent}. */
    onEvent(event: InputEvt): boolean;
    dispatchInputEvent(event: InputEvt): boolean;
    /**
     * Adds a new `InputMapper` to this' input pipeline.
     *
     * A `mapper` is really a relation that maps each event to no, one,
     * or many other events.
     *
     * @see {@link InputMapper}.
     */
    addInputMapper(mapper: InputMapper): void;
    getMatchingTools<Type extends BaseTool>(type: new (...args: any[]) => Type): Type[];
    onEditorDestroyed(): void;
}
