import Editor from '../Editor';
import { Color4 } from '@js-draw/math';
import { PointerEvt } from '../inputEvents';
import BaseTool from './BaseTool';
import { ToolLocalization } from './localization';
import TextRenderingStyle from '../rendering/TextRenderingStyle';
import { MutableReactiveValue } from '../util/ReactiveValue';
/** A tool that allows users to enter and edit text. */
export default class TextTool extends BaseTool {
    private editor;
    private localizationTable;
    private textStyleValue;
    private textStyle;
    private anchorControl;
    private contentTransform;
    private textEditOverlay;
    private textInputElem;
    private textMeasuringCtx;
    private removeExistingCommand;
    constructor(editor: Editor, description: string, localizationTable: ToolLocalization);
    private initTextMeasuringCanvas;
    private getTextAscent;
    private flushInput;
    private updateTextInput;
    private startTextInput;
    setEnabled(enabled: boolean): void;
    onPointerDown({ current, allPointers }: PointerEvt): boolean;
    onGestureCancel(): void;
    setFontFamily(fontFamily: string): void;
    setColor(color: Color4): void;
    setFontSize(size: number): void;
    getTextStyle(): TextRenderingStyle;
    getStyleValue(): MutableReactiveValue<TextRenderingStyle>;
    private setTextStyle;
    onDestroy(): void;
}
