import  createMenuOverlay  from '../../util/createMenuOverlay.mjs';
import  ClipboardHandler  from '../../../util/ClipboardHandler.mjs';
import  makeClipboardErrorHandlers  from './makeClipboardErrorHandlers.mjs';
const showSelectionContextMenu = async (selectionBox, editor, canvasAnchor, preferSelectionMenu, clearSelection) => {
    const localization = editor.localization;
    const showSelectionMenu = selectionBox?.getSelectedItemCount() && preferSelectionMenu;
    const noSelectionMenu = [
        {
            text: localization.selectionMenu__paste,
            icon: () => editor.icons.makePasteIcon(),
            key: () => {
                const clipboardHandler = new ClipboardHandler(editor, makeClipboardErrorHandlers(editor));
                void clipboardHandler.paste();
            },
        },
    ];
    const onActivated = await createMenuOverlay(editor, canvasAnchor, showSelectionMenu
        ? [
            {
                text: localization.selectionMenu__duplicate,
                icon: () => editor.icons.makeDuplicateSelectionIcon(),
                key: async () => {
                    await editor.dispatch(await selectionBox.duplicateSelectedObjects());
                },
            },
            {
                text: localization.selectionMenu__delete,
                icon: () => editor.icons.makeDeleteSelectionIcon(),
                key: async () => {
                    await editor.dispatch(selectionBox.deleteSelectedObjects());
                    clearSelection();
                },
            },
            {
                text: localization.selectionMenu__copyToClipboard,
                icon: () => editor.icons.makeCopyIcon(),
                key: () => {
                    const clipboardHandler = new ClipboardHandler(editor, makeClipboardErrorHandlers(editor));
                    void clipboardHandler.copy();
                },
            },
            ...noSelectionMenu,
        ]
        : noSelectionMenu);
    onActivated?.();
};
export default showSelectionContextMenu;
