import { Point2, Vec2 } from '@js-draw/math';
import Viewport from '../../Viewport';
type ScrollByCallback = (delta: Vec2) => void;
/**
 * Automatically scrolls the viewport such that the user's pointer is visible.
 */
export default class ToPointerAutoscroller {
    private viewport;
    private scrollByCanvasDelta;
    private started;
    private updateLoopId;
    private updateLoopRunning;
    private targetPoint;
    private scrollRate;
    constructor(viewport: Viewport, scrollByCanvasDelta: ScrollByCallback);
    private getScrollForPoint;
    start(): void;
    onPointerMove(pointerScreenPosition: Point2): void;
    stop(): void;
    private startUpdateLoop;
    private stopUpdateLoop;
}
export {};
