import  { pathToRenderable }  from '../../../rendering/RenderablePathSpec.mjs';
export default class SelectionBuilder {
    /** Renders a preview of the selection bounds */
    render(renderer, color) {
        renderer.drawPath(pathToRenderable(this.previewPath(), { fill: color }));
    }
    /** Converts the selection preview into a set of selected elements */
    resolve(image, viewport) {
        const path = this.previewPath();
        const filterComponents = (components) => {
            return components.filter((component) => {
                return component.isSelectable();
            });
        };
        let components;
        // If the bounding box is very small, search for items **near** the bounding box,
        // rather than in the bounding box.
        const clickSize = viewport.getSizeOfPixelOnCanvas() * 3;
        const isClick = path.bbox.maxDimension <= clickSize;
        if (isClick) {
            const searchRegionSize = viewport.visibleRect.maxDimension / 200;
            const minSizeBox = path.bbox.grownBy(searchRegionSize);
            components = image.getComponentsIntersecting(minSizeBox).filter((component) => {
                return minSizeBox.containsRect(component.getBBox()) || component.intersectsRect(minSizeBox);
            });
            components = filterComponents(components);
            if (components.length > 1) {
                components = [components[0]];
            }
        }
        else {
            components = filterComponents(this.resolveInternal(image));
        }
        return components;
    }
}
