import { Path, Rect2 } from '@js-draw/math';
import  SelectionBuilder  from './SelectionBuilder.mjs';
/**
 * Creates rectangle selections
 */
export default class RectSelectionBuilder extends SelectionBuilder {
    constructor(startPoint) {
        super();
        this.rect = Rect2.fromCorners(startPoint, startPoint);
    }
    onPointerMove(canvasPoint) {
        this.rect = this.rect.grownToPoint(canvasPoint);
    }
    previewPath() {
        return Path.fromRect(this.rect);
    }
    resolveInternal(image) {
        return image.getComponentsIntersecting(this.rect).filter((element) => {
            // Filter out the case where the selection rectangle is completely contained
            // within the element (and does not intersect it).
            // This is useful, for example, if a very large stroke is used as the background
            // for another drawing. This prevents the very large stroke from being selected
            // unless the selection touches one of its edges.
            return element.intersectsRect(this.rect);
        });
    }
}
