/**
 * @internal
 * @packageDocumentation
 */
import SerializableCommand from '../../commands/SerializableCommand';
import Editor from '../../Editor';
import { Mat33, Rect2, Point2 } from '@js-draw/math';
import Pointer from '../../Pointer';
import AbstractComponent from '../../components/AbstractComponent';
import Command from '../../commands/Command';
export default class Selection {
    private editor;
    private childwidgets;
    private originalRegion;
    private selectionTightBoundingBox;
    private transformers;
    private transform;
    private selectedElems;
    private outerContainer;
    private innerContainer;
    private backgroundElem;
    private hasParent;
    constructor(selectedElems: AbstractComponent[], editor: Editor, showContextMenu: (anchor: Point2) => void);
    getBackgroundElem(): HTMLElement;
    getTransform(): Mat33;
    get preTransformRegion(): Rect2;
    get region(): Rect2;
    /**
     * Computes and returns the bounding box of the selection without
     * any additional padding. Computes directly from the elements that are selected.
     * @internal
     */
    computeTightBoundingBox(): Rect2;
    get regionRotation(): number;
    get preTransformedScreenRegion(): Rect2;
    get preTransformedScreenRegionRotation(): number;
    getScreenRegion(): Rect2;
    get screenRegionRotation(): number;
    setTransform(transform: Mat33, preview?: boolean): void;
    private getDeltaZIndexToMoveSelectionToTop;
    finalizeTransform(): void | Promise<void>;
    /** Sends all selected elements to the bottom of the visible image. */
    sendToBack(): SerializableCommand | null;
    private static ApplyTransformationCommand;
    private previewTransformCmds;
    recomputeRegion(): boolean;
    padRegion(): void;
    getMinCanvasSize(): number;
    getSelectedItemCount(): number;
    updateUI(): void;
    private removedFromImage;
    private addRemoveSelectionFromImage;
    private removeDeletedElemsFromSelection;
    private activeHandle;
    private backgroundDragging;
    onDragStart(pointer: Pointer): boolean;
    onDragUpdate(pointer: Pointer): void;
    onDragEnd(): void;
    onDragCancel(): void;
    scrollTo(): boolean;
    deleteSelectedObjects(): Command;
    private selectionDuplicatedAnimationTimeout;
    private runSelectionDuplicatedAnimation;
    duplicateSelectedObjects(): Promise<Command>;
    snapSelectedObjectsToGrid(): void;
    setHandlesVisible(showHandles: boolean): void;
    addTo(elem: HTMLElement): void;
    setToPoint(point: Point2): void;
    cancelSelection(): void;
    getSelectedObjects(): AbstractComponent[];
}
