import  BaseTool  from '../BaseTool.mjs';
import  { selectAllKeyboardShortcut }  from '../keybindings.mjs';
import  SelectionTool  from './SelectionTool.mjs';
// Handles ctrl+a: Select all
export default class SelectAllShortcutHandler extends BaseTool {
    constructor(editor) {
        super(editor.notifier, editor.localization.selectAllTool);
        this.editor = editor;
    }
    canReceiveInputInReadOnlyEditor() {
        return true;
    }
    // @internal
    onKeyPress(event) {
        if (this.editor.shortcuts.matchesShortcut(selectAllKeyboardShortcut, event)) {
            const selectionTools = this.editor.toolController.getMatchingTools(SelectionTool);
            if (selectionTools.length > 0) {
                const selectionTool = selectionTools[0];
                selectionTool.setEnabled(true);
                selectionTool.setSelection(this.editor.image.getAllComponents());
                return true;
            }
        }
        return false;
    }
}
