import Editor from '../Editor';
import { PasteEvent } from '../inputEvents';
import BaseTool from './BaseTool';
/**
 * A tool that handles paste events (e.g. as triggered by ctrl+V).
 *
 * @example
 * While `ToolController` has a `PasteHandler` in its default list of tools,
 * if a non-default set is being used, `PasteHandler` can be added as follows:
 * ```ts
 * const toolController = editor.toolController;
 * toolController.addTool(new PasteHandler(editor));
 * ```
 */
export default class PasteHandler extends BaseTool {
    private editor;
    constructor(editor: Editor);
    onPaste(event: PasteEvent, onComplete?: () => void): boolean;
    private addComponentsFromPaste;
    private doSVGPaste;
    private doTextPaste;
    private doImagePaste;
}
