import { InputEvt } from '../../inputEvents';
import InputMapper from './InputMapper';
import KeyboardShortcutManager from '../../shortcuts/KeyboardShortcutManager';
import Viewport from '../../Viewport';
import Editor from '../../Editor';
/**
 * Provides keyboard shortcuts that provide some amount of control over
 * drawing (e.g. snap to grid, plane lock).
 */
export default class StrokeKeyboardControl extends InputMapper {
    private shortcuts;
    private viewport;
    private snapToGridEnabled;
    private angleLockEnabled;
    private startPointCanvas;
    constructor(shortcuts: KeyboardShortcutManager, viewport: Viewport);
    private xyAxesSnap;
    private mapPointerEvent;
    onEvent(event: InputEvt): boolean;
    static fromEditor(editor: Editor): StrokeKeyboardControl;
}
