import { InputEvt } from '../../inputEvents';
import InputMapper from './InputMapper';
import Viewport from '../../Viewport';
import Editor from '../../Editor';
declare enum StabilizerType {
    IntertialStabilizer = 0
}
interface InputStabilizerOptions {
    kind: StabilizerType.IntertialStabilizer;
    mass: number;
    springConstant: number;
    frictionCoefficient: number;
    maxPointDist: number;
    minSimilarityToFinalize: number;
    inertiaFraction: number;
    velocityDecayFactor: number;
}
export default class InputStabilizer extends InputMapper {
    private viewport;
    private readonly options;
    private stabilizer;
    private lastPointerEvent;
    constructor(viewport: Viewport, options?: InputStabilizerOptions);
    private mapPointerEvent;
    private emitPointerMove;
    onEvent(event: InputEvt): boolean;
    static fromEditor(editor: Editor): InputStabilizer;
}
export {};
