import { InputEvt } from '../../inputEvents';
import InputMapper from './InputMapper';
/**
 * The composition of multiple `InputMapper`s.
 */
export default class InputPipeline extends InputMapper {
    #private;
    onEvent(event: InputEvt): boolean;
    /**
     * Adds a new `InputMapper` to the *tail* of this pipeline.
     * Note that an instance of an `InputMapper` can only be used in a single
     * pipeline.
     */
    addToTail(mapper: InputMapper): void;
}
