import  InputMapper  from './InputMapper.mjs';
/**
 * An `InputMapper` that applies a function to all events it receives.
 *
 * Useful for automated testing.
 */
export default class FunctionMapper extends InputMapper {
    constructor(fn) {
        super();
        this.fn = fn;
    }
    onEvent(event) {
        return this.emit(this.fn(event));
    }
}
