var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _BaseTool_enabled, _BaseTool_group, _BaseTool_inputMapper, _BaseTool_readOnlyEditorChangeListener;
import  { EditorEventType }  from '../types.mjs';
import  { InputEvtType, }  from '../inputEvents.mjs';
import  { ReactiveValue }  from '../util/ReactiveValue.mjs';
class BaseTool {
    constructor(notifier, description) {
        this.notifier = notifier;
        this.description = description;
        _BaseTool_enabled.set(this, void 0);
        _BaseTool_group.set(this, null);
        _BaseTool_inputMapper.set(this, null);
        _BaseTool_readOnlyEditorChangeListener.set(this, null);
        __classPrivateFieldSet(this, _BaseTool_enabled, ReactiveValue.fromInitialValue(true), "f");
        __classPrivateFieldGet(this, _BaseTool_enabled, "f").onUpdate((enabled) => {
            // Ensure that at most one tool in the group is enabled.
            if (enabled) {
                __classPrivateFieldGet(this, _BaseTool_group, "f")?.notifyEnabled(this);
                this.notifier.dispatch(EditorEventType.ToolEnabled, {
                    kind: EditorEventType.ToolEnabled,
                    tool: this,
                });
            }
            else {
                this.notifier.dispatch(EditorEventType.ToolDisabled, {
                    kind: EditorEventType.ToolDisabled,
                    tool: this,
                });
            }
        });
    }
    /** Override this to allow this tool to be enabled in a read-only editor */
    canReceiveInputInReadOnlyEditor() {
        return false;
    }
    setInputMapper(mapper) {
        __classPrivateFieldSet(this, _BaseTool_inputMapper, mapper, "f");
        if (mapper) {
            mapper.setEmitListener((event) => this.dispatchEventToCallback(event));
        }
    }
    getInputMapper() {
        return __classPrivateFieldGet(this, _BaseTool_inputMapper, "f");
    }
    dispatchEventToCallback(event) {
        let exhaustivenessCheck;
        switch (event.kind) {
            case InputEvtType.PointerDownEvt:
                return this.onPointerDown(event);
            case InputEvtType.PointerMoveEvt:
                this.onPointerMove(event);
                break;
            case InputEvtType.PointerUpEvt:
                return this.onPointerUp(event) ?? false;
            case InputEvtType.GestureCancelEvt:
                this.onGestureCancel(event);
                break;
            case InputEvtType.WheelEvt:
                return this.onWheel(event);
            case InputEvtType.KeyPressEvent:
                return this.onKeyPress(event);
            case InputEvtType.KeyUpEvent:
                return this.onKeyUp(event);
            case InputEvtType.CopyEvent:
                return this.onCopy(event);
            case InputEvtType.PasteEvent:
                return this.onPaste(event);
            case InputEvtType.ContextMenu:
                return this.onContextMenu(event);
            default:
                exhaustivenessCheck = event;
                return exhaustivenessCheck;
        }
        return true;
    }
    // @internal
    onEvent(event) {
        if (__classPrivateFieldGet(this, _BaseTool_inputMapper, "f")) {
            return __classPrivateFieldGet(this, _BaseTool_inputMapper, "f").onEvent(event);
        }
        return this.dispatchEventToCallback(event);
    }
    /**
     * Returns true iff the tool handled the event and thus should receive additional
     * events.
     */
    onPointerDown(_event) {
        return false;
    }
    onPointerMove(_event) { }
    /**
     * Returns true iff there are additional pointers down and the tool should
     * remain active to handle the additional events.
     *
     * For most purposes, this should return `false` or nothing.
     */
    onPointerUp(_event) { }
    onGestureCancel(_event) { }
    onWheel(_event) {
        return false;
    }
    onCopy(_event) {
        return false;
    }
    onPaste(_event) {
        return false;
    }
    onKeyPress(_event) {
        return false;
    }
    onKeyUp(_event) {
        return false;
    }
    onContextMenu(_event) {
        return false;
    }
    /**
     * Return true if, while this tool is active, `_event` can be delivered to
     * another tool that is higher priority than this.
     * @internal May be renamed
     */
    eventCanBeDeliveredToNonActiveTool(_event) {
        return true;
    }
    setEnabled(enabled) {
        __classPrivateFieldGet(this, _BaseTool_enabled, "f").set(enabled);
    }
    isEnabled() {
        return __classPrivateFieldGet(this, _BaseTool_enabled, "f").get();
    }
    /**
     * Returns a {@link ReactiveValue} that updates based on whether this tool is
     * enabled.
     *
     * @example
     * ```ts
     * const tool = new SomeTool();
     *
     * // Watch for changes in enabled status
     * tool.enabledValue().onUpdate(enabled => doSomething(enabled));
     * ```
     */
    enabledValue() {
        return __classPrivateFieldGet(this, _BaseTool_enabled, "f");
    }
    // Connect this tool to a set of other tools, ensuring that at most one
    // of the tools in the group is enabled.
    setToolGroup(group) {
        if (this.isEnabled()) {
            group.notifyEnabled(this);
        }
        __classPrivateFieldSet(this, _BaseTool_group, group, "f");
    }
    getToolGroup() {
        if (__classPrivateFieldGet(this, _BaseTool_group, "f")) {
            return __classPrivateFieldGet(this, _BaseTool_group, "f");
        }
        return null;
    }
    // Called when the tool is removed/when the editor is destroyed.
    // Subclasses that override this method **must call super.onDestroy()**.
    onDestroy() {
        __classPrivateFieldGet(this, _BaseTool_readOnlyEditorChangeListener, "f")?.remove();
        __classPrivateFieldSet(this, _BaseTool_readOnlyEditorChangeListener, null, "f");
        __classPrivateFieldSet(this, _BaseTool_group, null, "f");
    }
}
_BaseTool_enabled = new WeakMap(), _BaseTool_group = new WeakMap(), _BaseTool_inputMapper = new WeakMap(), _BaseTool_readOnlyEditorChangeListener = new WeakMap();
export default BaseTool;
