import { ReactiveValue } from '../../../util/ReactiveValue';
export interface SnappedListItem<DataType> {
    element: HTMLElement;
    data: DataType;
}
type SnappedListItems<DataType> = Array<SnappedListItem<DataType>>;
export interface SnappedListControl<DataType> {
    container: HTMLElement;
    visibleItem: ReactiveValue<DataType | null>;
}
/**
 * Creates a list that snaps to each item and reports the selected item.
 */
declare const makeSnappedList: <DataType>(itemsValue: ReactiveValue<SnappedListItems<DataType>>) => SnappedListControl<DataType>;
export default makeSnappedList;
