import { MutableReactiveValue } from '../../../util/ReactiveValue';
import { ToolbarContext } from '../../types';
export interface CustomFilePickerProps {
    setOnCancelCallback(onCancel: () => void): void;
}
export type ShowCustomFilePickerCallback = (props: CustomFilePickerProps) => Promise<File[] | null>;
export interface FileInputOptions {
    readonly accepts?: string;
    readonly allowMultiSelect?: boolean;
    readonly customPickerAction?: ShowCustomFilePickerCallback;
}
/**
 * Creates a stylized file input. This file input can either use the system file picker, or a custom
 * one specified by `customPickerAction`.
 */
declare const makeFileInput: (labelText: string, context: ToolbarContext, { accepts, allowMultiSelect, customPickerAction }?: FileInputOptions) => {
    container: HTMLDivElement;
    input: HTMLInputElement;
    selectedFiles: MutableReactiveValue<File[]>;
    addTo: (parent: HTMLElement) => void;
};
export default makeFileInput;
