import Editor from '../../Editor';
import SelectionTool from '../../tools/SelectionTool/SelectionTool';
import { KeyPressEvent } from '../../inputEvents';
import { ToolbarLocalization } from '../localization';
import BaseToolWidget from './BaseToolWidget';
import HelpDisplay from '../utils/HelpDisplay';
import { SavedToolbuttonState } from './BaseWidget';
export default class SelectionToolWidget extends BaseToolWidget {
    private tool;
    private updateFormatMenu;
    private hasSelectionValue;
    constructor(editor: Editor, tool: SelectionTool, localization?: ToolbarLocalization);
    private resizeImageToSelection;
    protected onKeyPress(event: KeyPressEvent): boolean;
    protected getTitle(): string;
    protected createIcon(): Element;
    protected getHelpText(): string;
    protected createSelectionActions(helpDisplay?: HelpDisplay): {
        container: HTMLDivElement;
    };
    protected fillDropdown(dropdown: HTMLElement, helpDisplay?: HelpDisplay): boolean;
    serializeState(): SavedToolbuttonState;
    deserializeFrom(state: SavedToolbuttonState): void;
}
