import  ActionButtonWidget  from './ActionButtonWidget.mjs';
import  { ToolbarWidgetTag }  from './BaseWidget.mjs';
import  { saveKeyboardShortcut }  from './keybindings.mjs';
class SaveActionWidget extends ActionButtonWidget {
    constructor(editor, localization, saveCallback, labelOverride = {}) {
        super(editor, 'save-button', 
        // Creates an icon
        () => {
            return labelOverride.icon ?? editor.icons.makeSaveIcon();
        }, labelOverride.label ?? localization.save, saveCallback);
        this.setTags([ToolbarWidgetTag.Save]);
    }
    shouldAutoDisableInReadOnlyEditor() {
        return false;
    }
    onKeyPress(event) {
        if (this.editor.shortcuts.matchesShortcut(saveKeyboardShortcut, event)) {
            this.clickAction();
            return true;
        }
        // Run any default actions registered by the parent class.
        return super.onKeyPress(event);
    }
    mustBeInToplevelMenu() {
        return true;
    }
}
export default SaveActionWidget;
