import  BaseWidget  from './BaseWidget.mjs';
export default class OverflowWidget extends BaseWidget {
    constructor(editor, localizationTable) {
        super(editor, 'overflow-widget', localizationTable);
        this.overflowChildren = [];
        this.container.classList.add('toolbar-overflow-widget');
        // Make the dropdown openable
        this.container.classList.add('dropdownShowable');
        this.overflowContainer ??= document.createElement('div');
    }
    shouldAutoDisableInReadOnlyEditor() {
        return false;
    }
    getTitle() {
        return this.localizationTable.toggleOverflow;
    }
    createIcon() {
        return this.editor.icons.makeOverflowIcon();
    }
    handleClick() {
        this.setDropdownVisible(!this.isDropdownVisible());
    }
    fillDropdown(dropdown) {
        this.overflowContainer ??= document.createElement('div');
        if (this.overflowContainer.parentElement) {
            this.overflowContainer.remove();
        }
        this.overflowContainer.classList.add('toolbar-overflow-widget-overflow-list');
        dropdown.appendChild(this.overflowContainer);
        return true;
    }
    /**
     * Removes all `BaseWidget`s from this and returns them.
     */
    clearChildren() {
        this.overflowContainer.replaceChildren();
        this.container.classList.remove('horizontal');
        const overflowChildren = this.overflowChildren;
        this.overflowChildren = [];
        return overflowChildren;
    }
    getChildWidgets() {
        return [...this.overflowChildren];
    }
    hasAsChild(widget) {
        for (const otherWidget of this.overflowChildren) {
            if (widget === otherWidget) {
                return true;
            }
        }
        return false;
    }
    /**
     * Adds `widget` to this.
     * `widget`'s previous parent is still responsible
     * for serializing/deserializing its state.
     */
    addToOverflow(widget) {
        this.overflowChildren.push(widget);
        widget.addTo(this.overflowContainer);
        widget.setIsToplevel(false);
        // Switch to a horizontal layout if enough children
        if (this.overflowChildren.length > 2) {
            this.container.classList.add('horizontal');
        }
    }
    // This always returns false.
    // Don't try to move the overflow menu to itself.
    canBeInOverflowMenu() {
        return false;
    }
}
