import Editor from '../../Editor';
import { ToolbarLocalization } from '../localization';
import BaseWidget from './BaseWidget';
export default class OverflowWidget extends BaseWidget {
    private overflowChildren;
    private overflowContainer;
    constructor(editor: Editor, localizationTable?: ToolbarLocalization);
    protected shouldAutoDisableInReadOnlyEditor(): boolean;
    protected getTitle(): string;
    protected createIcon(): Element | null;
    protected handleClick(): void;
    protected fillDropdown(dropdown: HTMLElement): boolean;
    /**
     * Removes all `BaseWidget`s from this and returns them.
     */
    clearChildren(): BaseWidget[];
    getChildWidgets(): BaseWidget[];
    hasAsChild(widget: BaseWidget): boolean;
    /**
     * Adds `widget` to this.
     * `widget`'s previous parent is still responsible
     * for serializing/deserializing its state.
     */
    addToOverflow(widget: BaseWidget): void;
    canBeInOverflowMenu(): boolean;
}
