import { RenderableImage } from '../../../rendering/renderers/AbstractRenderer';
/** Handles filtering and other operations on an image. */
export declare class ImageWrapper {
    private imageBase64Url;
    private preview;
    private onUrlUpdate;
    private readonly originalSrc;
    private altText;
    private constructor();
    private updateImageData;
    decreaseSize(resizeFactor?: number): void;
    reset(): void;
    isChanged(): boolean;
    isLarge(): boolean;
    getBase64Url(): string;
    getAltText(): string;
    setAltText(text: string): void;
    static fromSrcAndPreview(initialBase64Src: string, preview: HTMLImageElement, onUrlUpdate: () => void): ImageWrapper;
    static fromRenderable(renderable: RenderableImage, onUrlUpdate: () => void): {
        wrapper: ImageWrapper;
        preview: HTMLImageElement;
    };
}
