import Editor from '../../Editor';
import PanZoom from '../../tools/PanZoom';
import { ToolbarLocalization } from '../localization';
import BaseToolWidget from './BaseToolWidget';
import { SavedToolbuttonState } from './BaseWidget';
import HelpDisplay from '../utils/HelpDisplay';
/** This toolbar widget allows controlling the editor's {@link PanZoom} tool(s). */
export default class HandToolWidget extends BaseToolWidget {
    private allowTogglingBaseTool;
    protected overridePanZoomTool: PanZoom;
    constructor(editor: Editor, tool: PanZoom, localizationTable: ToolbarLocalization);
    private static getPrimaryHandTool;
    private static getOverrideHandTool;
    protected shouldAutoDisableInReadOnlyEditor(): boolean;
    protected getTitle(): string;
    protected createIcon(): Element;
    protected handleClick(): void;
    protected getHelpText(): string;
    protected fillDropdown(dropdown: HTMLElement, helpDisplay?: HelpDisplay): boolean;
    setSelected(selected: boolean): void;
    serializeState(): SavedToolbuttonState;
    deserializeFrom(state: SavedToolbuttonState): void;
}
