import  ActionButtonWidget  from './ActionButtonWidget.mjs';
import  { ToolbarWidgetTag }  from './BaseWidget.mjs';
import  { exitKeyboardShortcut }  from './keybindings.mjs';
class ExitActionWidget extends ActionButtonWidget {
    constructor(editor, localization, saveCallback, labelOverride = {}) {
        super(editor, 'exit-button', 
        // Creates an icon
        () => {
            return labelOverride.icon ?? editor.icons.makeCloseIcon();
        }, labelOverride.label ?? localization.exit, saveCallback);
        this.setTags([ToolbarWidgetTag.Exit]);
    }
    shouldAutoDisableInReadOnlyEditor() {
        return false;
    }
    onKeyPress(event) {
        if (this.editor.shortcuts.matchesShortcut(exitKeyboardShortcut, event)) {
            this.clickAction();
            return true;
        }
        return super.onKeyPress(event);
    }
    mustBeInToplevelMenu() {
        return true;
    }
}
export default ExitActionWidget;
