import Editor from '../../Editor';
import Eraser from '../../tools/Eraser';
import { ToolbarLocalization } from '../localization';
import HelpDisplay from '../utils/HelpDisplay';
import BaseToolWidget from './BaseToolWidget';
import { SavedToolbuttonState } from './BaseWidget';
export default class EraserToolWidget extends BaseToolWidget {
    private tool;
    private updateInputs;
    constructor(editor: Editor, tool: Eraser, localizationTable?: ToolbarLocalization);
    protected getHelpText(): string;
    protected getTitle(): string;
    private makeIconForType;
    protected createIcon(): Element;
    private static idCounter;
    private makeEraserTypeSelector;
    protected fillDropdown(dropdown: HTMLElement, helpDisplay?: HelpDisplay): boolean;
    serializeState(): SavedToolbuttonState;
    deserializeFrom(state: SavedToolbuttonState): void;
}
