import  BaseWidget  from './BaseWidget.mjs';
import  { toolbarCSSPrefix }  from '../constants.mjs';
const isToolWidgetFocused = () => {
    const currentFocus = [...document.querySelectorAll('*:focus')];
    return (currentFocus.length &&
        currentFocus.some((elem) => elem.classList.contains(`${toolbarCSSPrefix}button`)));
};
export default class BaseToolWidget extends BaseWidget {
    constructor(editor, targetTool, id, localizationTable) {
        super(editor, id, localizationTable);
        this.targetTool = targetTool;
        this.targetTool.enabledValue().onUpdateAndNow((enabled) => {
            if (enabled) {
                this.setSelected(true);
                // Transfer focus to the current button, only if another toolbar button is
                // focused.
                // This prevents pressing "space" from triggering a different action when
                // the current is selected.
                if (isToolWidgetFocused()) {
                    this.focus();
                }
            }
            else {
                this.setSelected(false);
                this.setDropdownVisible(false);
            }
        });
    }
    shouldAutoDisableInReadOnlyEditor() {
        return !this.targetTool.canReceiveInputInReadOnlyEditor();
    }
    handleClick() {
        if (this.hasDropdown) {
            if (!this.targetTool.isEnabled()) {
                this.targetTool.setEnabled(true);
                this.activateDropdown();
            }
            else {
                this.setDropdownVisible(!this.isDropdownVisible());
            }
        }
        else {
            this.targetTool.setEnabled(!this.targetTool.isEnabled());
        }
    }
    onKeyPress(event) {
        if (this.isSelected() && event.code === 'Space' && this.hasDropdown) {
            this.handleClick();
            return true;
        }
        return false;
    }
    addTo(parent) {
        const result = super.addTo(parent);
        this.setSelected(this.targetTool.isEnabled());
        return result;
    }
}
