import Editor from '../../Editor';
import BaseTool from '../../tools/BaseTool';
import { KeyPressEvent } from '../../inputEvents';
import { ToolbarLocalization } from '../localization';
import BaseWidget from './BaseWidget';
export default abstract class BaseToolWidget extends BaseWidget {
    protected targetTool: BaseTool;
    constructor(editor: Editor, targetTool: BaseTool, id: string, localizationTable?: ToolbarLocalization);
    protected shouldAutoDisableInReadOnlyEditor(): boolean;
    protected handleClick(): void;
    protected onKeyPress(event: KeyPressEvent): boolean;
    addTo(parent: HTMLElement): HTMLElement;
}
