import { Vec2 } from '@js-draw/math';
interface DragStatistics {
    roughlyClick: boolean;
    endTimestamp: number;
    displacement: Vec2;
}
interface DraggableOptions {
    draggableChildElements: HTMLElement[];
    onDrag(deltaX: number, deltaY: number, totalDisplacement: Vec2): void;
    onDragEnd(dragStatistics: DragStatistics): void;
}
export interface DragControl {
    removeListeners(): void;
}
declare const makeDraggable: (dragElement: HTMLElement, options: DraggableOptions) => DragControl;
export default makeDraggable;
