import { ToolbarContext } from '../types';
export interface HelpRecord {
    readonly helpText: string;
    /**
     * Elements that have `helpText`. Conceptually, these
     * `HTMLElement`s form a single control (e.g. different radio
     * buttons in a button group).
     *
     * The elements are all shown at once by a `HelpDisplay`.
     */
    readonly targetElements: HTMLElement[];
}
/**
 * Creates and manages an overlay that shows help text for a set of
 * `HTMLElement`s.
 *
 * @see {@link BaseWidget.fillDropdown}.
 */
export default class HelpDisplay {
    #private;
    private createOverlay;
    private context;
    /** Constructed internally by BaseWidget. @internal */
    constructor(createOverlay: (htmlElement: HTMLElement) => void, context: ToolbarContext);
    /** @internal */
    showHelpOverlay(): void;
    /** Marks `helpText` as associated with a single `targetElement`. */
    registerTextHelpForElement(targetElement: HTMLElement, helpText: string): void;
    /** Marks `helpText` as associated with all elements in `targetElements`. */
    registerTextHelpForElements(targetElements: HTMLElement[], helpText: string): void;
    /** Returns true if any help text has been registered. */
    hasHelpText(): boolean;
    /**
     * Creates and returns a button that toggles the help display.
     */
    createToggleButton(): HTMLElement;
}
