import  { defaultToolbarUtilsLocalization }  from './utils/localization.mjs';
export const defaultToolbarLocalization = {
    ...defaultToolbarUtilsLocalization,
    pen: 'Pen',
    eraser: 'Eraser',
    select: 'Select',
    handTool: 'Pan',
    zoom: 'Zoom',
    image: 'Image',
    reformatSelection: 'Format selection',
    inputAltText: 'Alt text',
    decreaseImageSize: 'Decrease size',
    resetImage: 'Reset',
    chooseFile: 'Choose file',
    dragAndDropHereOrBrowse: 'Drag and drop here\nor\n{{browse}}',
    submit: 'Submit',
    addAll: 'Add all',
    cancel: 'Cancel',
    resetView: 'Reset view',
    thicknessLabel: 'Thickness',
    colorLabel: 'Color',
    fontLabel: 'Font',
    textSize: 'Size',
    resizeImageToSelection: 'Resize image to selection',
    deleteSelection: 'Delete selection',
    duplicateSelection: 'Duplicate selection',
    exit: 'Exit',
    save: 'Save',
    undo: 'Undo',
    redo: 'Redo',
    fullStrokeEraser: 'Full stroke eraser',
    selectPenType: 'Pen type',
    selectShape: 'Shape',
    pickColorFromScreen: 'Pick color from screen',
    clickToPickColorAnnouncement: 'Click on the screen to pick a color',
    colorSelectionCanceledAnnouncement: 'Color selection canceled',
    selectionTool__lassoSelect: 'Freeform selection',
    selectionTool__lassoSelect__help: 'When enabled, dragging creates a freeform (lasso) selection.',
    selectionToolKeyboardShortcuts: 'Selection tool: Use arrow keys to move selected items, lowercase/uppercase ‘i’ and ‘o’ to resize.',
    documentProperties: 'Page',
    backgroundColor: 'Background color',
    imageWidthOption: 'Width',
    imageHeightOption: 'Height',
    useGridOption: 'Grid',
    enableAutoresizeOption: 'Auto-resize',
    toggleOverflow: 'More',
    about: 'About',
    inputStabilization: 'Stabilization',
    strokeAutocorrect: 'Autocorrect',
    pressureSensitivity: 'Pressure',
    touchPanning: 'Scroll with touch',
    roundedTipPen: 'Round',
    roundedTipPen2: 'Polyline',
    flatTipPen: 'Flat',
    arrowPen: 'Arrow',
    linePen: 'Line',
    outlinedRectanglePen: 'Outlined rectangle',
    filledRectanglePen: 'Filled rectangle',
    outlinedCirclePen: 'Outlined circle',
    lockRotation: 'Lock rotation',
    paste: 'Paste',
    errorImageHasZeroSize: 'Error: Image has zero size',
    describeTheImage: 'Image description',
    fileInput__loading: 'Loading...',
    fileInput__andNMoreFiles: (n) => `(...${n} more)`,
    // Help text
    penDropdown__baseHelpText: 'This tool draws shapes or freehand lines.',
    penDropdown__colorHelpText: "Changes the pen's color",
    penDropdown__thicknessHelpText: 'Changes the thickness of strokes drawn by the pen.',
    penDropdown__penTypeHelpText: 'Changes the pen style.\n\nEither a “pen” style or “shape” can be chosen. Choosing a “pen” style draws freehand lines. Choosing a “shape” draws shapes.',
    penDropdown__autocorrectHelpText: 'Converts approximate freehand lines and rectangles to perfect ones.\n\nThe pen must be held stationary at the end of a stroke to trigger a correction.',
    penDropdown__stabilizationHelpText: 'Draws smoother strokes.\n\nThis also adds a short delay between the mouse/stylus and the stroke.',
    penDropdown__pressureSensitivityHelpText: 'Changes the thickness of strokes according to how hard you press, when using a compatible device like a stylus.',
    handDropdown__baseHelpText: 'This tool is responsible for scrolling, rotating, and zooming the editor.',
    handDropdown__zoomInHelpText: 'Zooms in.',
    handDropdown__zoomOutHelpText: 'Zooms out.',
    handDropdown__resetViewHelpText: 'Resets the zoom level to 100% and resets scroll.',
    handDropdown__zoomDisplayHelpText: 'Shows the current zoom level. 100% shows the image at its actual size.',
    handDropdown__touchPanningHelpText: 'When enabled, touchscreen gestures move the image rather than select or draw.',
    handDropdown__lockRotationHelpText: 'When enabled, prevents touch gestures from rotating the screen.',
    eraserDropdown__baseHelpText: 'This tool removes strokes, images, and text under the cursor.',
    eraserDropdown__thicknessHelpText: 'Changes the size of the eraser.',
    eraserDropdown__fullStrokeEraserHelpText: 'When in full-stroke mode, entire shapes are erased.\n\nWhen not in full-stroke mode, shapes can be partially erased.',
    selectionDropdown__baseHelpText: 'Selects content and manipulates the selection',
    selectionDropdown__resizeToHelpText: "Crops the drawing to the size of what's currently selected.\n\nIf auto-resize is enabled, it will be disabled.",
    selectionDropdown__deleteHelpText: 'Erases selected items.',
    selectionDropdown__duplicateHelpText: 'Makes a copy of selected items.',
    selectionDropdown__changeColorHelpText: 'Changes the color of selected items.',
    pageDropdown__baseHelpText: "Controls the drawing canvas' background color, pattern, and size.",
    pageDropdown__backgroundColorHelpText: 'Changes the background color of the drawing canvas.',
    pageDropdown__gridCheckboxHelpText: 'Enables/disables a background grid pattern.',
    pageDropdown__autoresizeCheckboxHelpText: 'When checked, the page grows to fit the drawing.\n\nWhen unchecked, the page is visible and its size can be set manually.',
    pageDropdown__aboutButtonHelpText: 'Shows version, debug, and other information.',
    colorPickerPipetteHelpText: 'Picks a color from the screen.',
    colorPickerToggleHelpText: 'Opens/closes the color picker.',
    closeSidebar: (toolName) => `Close sidebar for ${toolName}`,
    dropdownShown: (toolName) => `Menu for ${toolName} shown`,
    dropdownHidden: (toolName) => `Menu for ${toolName} hidden`,
    zoomLevel: (zoomPercent) => `Zoom: ${zoomPercent}%`,
    colorChangedAnnouncement: (color) => `Color changed to ${color}`,
    imageSize: (size, units) => `Image size: ${size} ${units}`,
    imageLoadError: (message) => `Error loading image: ${message}`,
};
