import Editor from '../Editor';
import { ToolbarLocalization } from './localization';
import BaseWidget from './widgets/BaseWidget';
import AbstractToolbar, { SpacerOptions } from './AbstractToolbar';
/**
 * @example
 *
 * ```ts,runnable
 * import { makeDropdownToolbar, Editor } from 'js-draw';
 *
 * const editor = new Editor(document.body);
 * const toolbar = makeDropdownToolbar(editor);
 * toolbar.addDefaults();
 *
 * toolbar.addExitButton(editor => {
 *   // TODO
 * });
 *
 * toolbar.addSaveButton(editor => {
 *   // TODO
 * });
 * ```
 *
 * Returns a subclass of {@link AbstractToolbar}.
 *
 * @see
 * - {@link makeEdgeToolbar}
 * - {@link AbstractToolbar.addSaveButton}
 * - {@link AbstractToolbar.addExitButton}
 */
export declare const makeDropdownToolbar: (editor: Editor) => DropdownToolbar;
export default class DropdownToolbar extends AbstractToolbar {
    protected container: HTMLElement;
    private resizeObserver;
    private widgetOrderCounter;
    private overflowWidget;
    /** @internal */
    constructor(editor: Editor, parent: HTMLElement, localizationTable: ToolbarLocalization);
    private reLayoutQueued;
    private queueReLayout;
    private reLayout;
    protected addWidgetInternal(widget: BaseWidget): void;
    protected removeWidgetInternal(widget: BaseWidget): void;
    addSpacer(options?: Partial<SpacerOptions>): void;
    /**
     * Adds a widget that toggles the overflow menu. Call `addOverflowWidget` to ensure
     * that this widget is in the correct space (if shown).
     *
     * @example
     * ```ts
     * toolbar.addDefaultToolWidgets();
     * toolbar.addOverflowWidget();
     * toolbar.addDefaultActionButtons();
     * ```
     * shows the overflow widget between the default tool widgets and the default action buttons,
     * if shown.
     */
    addOverflowWidget(): void;
    /**
     * Adds both the default tool widgets and action buttons. Equivalent to
     * ```ts
     * toolbar.addDefaultToolWidgets();
     * toolbar.addOverflowWidget();
     * toolbar.addDefaultActionButtons();
     * ```
     */
    addDefaults(): void;
    protected onRemove(): void;
}
