import  Pointer, { PointerDevice }  from '../Pointer.mjs';
import  { InputEvtType }  from '../inputEvents.mjs';
import  getUniquePointerId  from './getUniquePointerId.mjs';
/**
 * Dispatch a pen event to the currently selected tool.
 * Intended for unit tests.
 *
 * @see {@link sendTouchEvent}
 */
const sendPenEvent = (editor, eventType, point, allPointers, deviceType = PointerDevice.Pen) => {
    const id = getUniquePointerId(allPointers ?? []);
    const mainPointer = Pointer.ofCanvasPoint(point, eventType !== InputEvtType.PointerUpEvt, editor.viewport, id, deviceType);
    editor.toolController.dispatchInputEvent({
        kind: eventType,
        allPointers: allPointers ?? [mainPointer],
        current: mainPointer,
    });
    return mainPointer;
};
export default sendPenEvent;
