import  Editor  from '../Editor.mjs';
import  { InputEvtType }  from '../inputEvents.mjs';
import  guessKeyCodeFromKey  from '../util/guessKeyCodeFromKey.mjs';
const sendKeyPressRelease = (target, key) => {
    if (target instanceof Editor) {
        target.sendKeyboardEvent(InputEvtType.KeyPressEvent, key);
        target.sendKeyboardEvent(InputEvtType.KeyUpEvent, key);
    }
    else {
        const code = guessKeyCodeFromKey(key);
        target.dispatchEvent(new KeyboardEvent('keydown', { key, code }));
        target.dispatchEvent(new KeyboardEvent('keyup', { key, code }));
    }
};
export default sendKeyPressRelease;
