import  sendKeyPressRelease  from './sendKeyPressRelease.mjs';
/** Sets the content of the given `input` or textarea to be `text`. */
const fillInput = (input, text, { clear = false } = {}) => {
    const dispatchUpdate = () => {
        input.dispatchEvent(new InputEvent('input'));
    };
    if (clear) {
        input.value = '';
        dispatchUpdate();
    }
    for (const character of text.split('')) {
        input.value += character;
        sendKeyPressRelease(input, character);
        dispatchUpdate();
    }
};
export default fillInput;
