import  { RenderingMode }  from '../rendering/Display.mjs';
import  Editor  from '../Editor.mjs';
import  getLocalizationTable  from '../localizations/getLocalizationTable.mjs';
/** Creates an editor. Should only be used in test files. */
export default (settings) => {
    if (jest === undefined) {
        throw new Error('Files in the testing/ folder should only be used in tests!');
    }
    return new Editor(document.body, {
        renderingMode: RenderingMode.DummyRenderer,
        localization: getLocalizationTable(['en']),
        ...settings,
    });
};
