import { Vec2 } from '@js-draw/math';
import  AbstractRenderer  from './AbstractRenderer.mjs';
// Outputs a description of what was rendered.
export default class TextOnlyRenderer extends AbstractRenderer {
    constructor(viewport, localizationTable) {
        super(viewport);
        this.localizationTable = localizationTable;
        this.descriptionBuilder = [];
        this.pathCount = 0;
        this.textNodeCount = 0;
        this.imageNodeCount = 0;
    }
    displaySize() {
        // We don't have a graphical display, export a reasonable size.
        return Vec2.of(500, 500);
    }
    clear() {
        this.descriptionBuilder = [];
        this.pathCount = 0;
        this.textNodeCount = 0;
        this.imageNodeCount = 0;
    }
    getDescription() {
        return [
            this.localizationTable.pathNodeCount(this.pathCount),
            ...(this.textNodeCount > 0 ? [this.localizationTable.textNodeCount(this.textNodeCount)] : []),
            ...(this.imageNodeCount > 0
                ? [this.localizationTable.imageNodeCount(this.imageNodeCount)]
                : []),
            ...this.descriptionBuilder,
        ].join('\n');
    }
    beginPath(_startPoint) { }
    endPath(_style) {
        this.pathCount++;
    }
    lineTo(_point) { }
    moveTo(_point) { }
    traceCubicBezierCurve(_p1, _p2, _p3) { }
    traceQuadraticBezierCurve(_controlPoint, _endPoint) { }
    drawText(text, _transform, _style) {
        this.descriptionBuilder.push(this.localizationTable.textNode(text));
        this.textNodeCount++;
    }
    drawImage(image) {
        const label = image.label
            ? this.localizationTable.imageNode(image.label)
            : this.localizationTable.unlabeledImageNode;
        this.descriptionBuilder.push(label);
        this.imageNodeCount++;
    }
    isTooSmallToRender(rect) {
        return rect.maxDimension < 15 / this.getSizeOfCanvasPixelOnScreen();
    }
    drawPoints(..._points) { }
}
