import { LoadSaveDataTable } from '../../components/AbstractComponent';
import { Mat33, Rect2, Point2, Vec2 } from '@js-draw/math';
import Viewport from '../../Viewport';
import RenderingStyle from '../RenderingStyle';
import TextRenderingStyle from '../TextRenderingStyle';
import AbstractRenderer, { RenderableImage } from './AbstractRenderer';
import RenderablePathSpec from '../RenderablePathSpec';
export declare const renderedStylesheetId = "js-draw-style-sheet";
type FromViewportOptions = {
    sanitize?: boolean;
    /**
     * Rather than having the top left of the `viewBox` set to (0, 0),
     * if `useViewBoxForPositioning` is `true`, the `viewBox`'s top left
     * is based on the top left of the rendering viewport's `visibleRect`.
     */
    useViewBoxForPositioning?: boolean;
};
type DrawWithSVGParentContext = {
    sanitize: boolean;
};
/**
 * Renders onto an `SVGElement`.
 *
 * @see {@link Editor.toSVG}
 */
export default class SVGRenderer extends AbstractRenderer {
    private elem;
    private sanitize;
    private lastPathStyle;
    private lastPathString;
    private lastContainerIDList;
    private objectElems;
    private overwrittenAttrs;
    /**
     * Creates a renderer that renders onto `elem`. If `sanitize`, don't render potentially untrusted data.
     *
     * `viewport` is used to determine the translation/rotation/scaling/output size of the rendered
     * data.
     */
    constructor(elem: SVGSVGElement, viewport: Viewport, sanitize?: boolean);
    private addStyleSheet;
    setRootSVGAttribute(name: string, value: string | null): void;
    displaySize(): Vec2;
    clear(): void;
    protected addPathToSVG(): SVGPathElement | null;
    drawPath(pathSpec: RenderablePathSpec): void;
    private transformFrom;
    private textContainer;
    private textContainerTransform;
    private textParentStyle;
    drawText(text: string, transform: Mat33, style: TextRenderingStyle): void;
    drawImage(image: RenderableImage): void;
    startObject(boundingBox: Rect2): void;
    endObject(loaderData?: LoadSaveDataTable, elemClassNames?: string[]): void;
    private unimplementedMessage;
    protected beginPath(_startPoint: Point2): void;
    protected endPath(_style: RenderingStyle): void;
    protected lineTo(_point: Point2): void;
    protected moveTo(_point: Point2): void;
    protected traceCubicBezierCurve(_controlPoint1: Point2, _controlPoint2: Point2, _endPoint: Point2): void;
    protected traceQuadraticBezierCurve(_controlPoint: Point2, _endPoint: Point2): void;
    drawPoints(...points: Point2[]): void;
    /**
     * Adds a **copy** of the given element directly to the container
     * SVG element, **without applying transforms**.
     *
     * If `sanitize` is enabled, this does nothing.
     */
    drawSVGElem(elem: SVGElement): void;
    /**
     * Allows rendering directly to the underlying SVG element. Rendered
     * content is added to a `<g>` element that's passed as `parent` to `callback`.
     *
     * **Note**: Unlike {@link drawSVGElem}, this method can be used even if `sanitize` is `true`.
     * In this case, it's the responsibility of `callback` to ensure that everything added
     * to `parent` is safe to render.
     */
    drawWithSVGParent(callback: (parent: SVGGElement, context: DrawWithSVGParentContext) => void): void;
    isTooSmallToRender(_rect: Rect2): boolean;
    /**
     * Creates a new SVG element and `SVGRenerer` with `width`, `height`, `viewBox`,
     * and other metadata attributes set for the given `Viewport`.
     *
     * If `options` is a `boolean`, it is interpreted as whether to sanitize (not add unknown
     * SVG entities to) the output.
     */
    static fromViewport(viewport: Viewport, options?: FromViewportOptions | boolean): {
        element: SVGSVGElement;
        renderer: SVGRenderer;
    };
}
export {};
