import  CanvasRenderer  from './CanvasRenderer.mjs';
class CanvasInkPresenter {
    constructor(canvas, viewport) {
        this.viewport = viewport;
        this.enabled = new Map();
        this.presenter = null;
        this.style = { color: 'black', diameter: 2 };
        if ('ink' in navigator && navigator.ink) {
            const ink = navigator.ink;
            ink.requestPresenter({ presentationArea: canvas }).then((presenter) => {
                this.presenter = presenter;
            });
        }
    }
    setEnabled(pointerId, enabled) {
        this.enabled.set(pointerId, enabled);
    }
    updateStyle(style) {
        const colorString = style.color.toString();
        // style.diameter must be a postive integer.
        this.style = {
            color: colorString,
            diameter: Math.ceil(style.width / this.viewport.getSizeOfPixelOnCanvas()),
        };
    }
    onEvent(event) {
        if (this.presenter && this.enabled.get(event.pointerId) && event.isTrusted) {
            this.presenter.updateInkTrailStartPoint(event, this.style);
        }
    }
}
/** A canvas that uses the web ink API for accelerated inking. */
export default class AcceleratedInkingCanvasRenderer extends CanvasRenderer {
    constructor(ctx, viewport) {
        super(ctx, viewport);
        this.inkPresenter = new CanvasInkPresenter(ctx.canvas, viewport);
    }
    getDraftInkPresenter() {
        return this.inkPresenter;
    }
    onEvent(event) {
        this.inkPresenter.onEvent(event);
    }
}
