import { StrokeStyle } from '../RenderingStyle';
import { DraftInkPresenter } from './AbstractRenderer';
import CanvasRenderer from './CanvasRenderer';
import Viewport from '../../Viewport';
declare class CanvasInkPresenter implements DraftInkPresenter {
    private viewport;
    private enabled;
    private presenter;
    private style;
    constructor(canvas: HTMLCanvasElement, viewport: Viewport);
    setEnabled(pointerId: number, enabled: boolean): void;
    updateStyle(style: StrokeStyle): void;
    onEvent(event: PointerEvent): void;
}
/** A canvas that uses the web ink API for accelerated inking. */
export default class AcceleratedInkingCanvasRenderer extends CanvasRenderer {
    private inkPresenter;
    constructor(ctx: CanvasRenderingContext2D, viewport: Viewport);
    getDraftInkPresenter(): CanvasInkPresenter;
    onEvent(event: PointerEvent): void;
}
export {};
