import { ImageNode } from '../../image/EditorImage';
import { Rect2 } from '@js-draw/math';
import Viewport from '../../Viewport';
import AbstractRenderer from '../renderers/AbstractRenderer';
import { CacheState } from './types';
export default class RenderingCacheNode {
    readonly region: Rect2;
    private readonly cacheState;
    private instantiatedChildren;
    private parent;
    private cachedRenderer;
    private renderedIds;
    private renderedMaxZIndex;
    constructor(region: Rect2, cacheState: CacheState);
    generateParent(): RenderingCacheNode;
    private generateChildren;
    private getChildren;
    smallestChildContaining(rect: Rect2): RenderingCacheNode | null;
    private renderingWouldBeHighEnoughResolution;
    private allChildrenCanRender;
    private computeSortedByLeafIds;
    private idsOfIntersecting;
    private allRenderedIdsIn;
    private renderingIsUpToDate;
    renderItems(screenRenderer: AbstractRenderer, items: ImageNode[], viewport: Viewport): void;
    private isEmpty;
    private onRegionDealloc;
    private checkRep;
}
