import { Mat33, Rect2 } from '@js-draw/math';
import AbstractRenderer from '../renderers/AbstractRenderer';
import { BeforeDeallocCallback, CacheState } from './types';
export default class CacheRecord {
    private onBeforeDeallocCallback;
    private cacheState;
    private renderer;
    private lastUsedCycle;
    private allocd;
    allocCount: number;
    constructor(onBeforeDeallocCallback: BeforeDeallocCallback | null, cacheState: CacheState);
    startRender(): AbstractRenderer;
    dealloc(): void;
    isAllocd(): boolean;
    realloc(newDeallocCallback: BeforeDeallocCallback): void;
    getLastUsedCycle(): number;
    getTransform(drawTo: Rect2): Mat33;
    setRenderingRegion(drawTo: Rect2): void;
}
