import  { cloneStyle, styleFromJSON, styleToJSON }  from './RenderingStyle.mjs';
export const cloneTextStyle = (style) => {
    return {
        ...style,
        renderingStyle: cloneStyle(style.renderingStyle),
    };
};
/** `json` can either be a `string` or an `object`. */
export const textStyleFromJSON = (json) => {
    if (typeof json === 'string') {
        json = JSON.parse(json);
    }
    if (typeof json.fontFamily !== 'string') {
        throw new Error('Serialized textStyle missing string fontFamily attribute!');
    }
    const style = {
        renderingStyle: styleFromJSON(json.renderingStyle),
        size: json.size,
        fontWeight: json.fontWeight,
        fontVariant: json.fontVariant,
        fontFamily: json.fontFamily,
    };
    return style;
};
export const textStyleToJSON = (style) => {
    return {
        ...style,
        renderingStyle: styleToJSON(style.renderingStyle),
    };
};
