import { Color4 } from '@js-draw/math';
export interface StrokeStyle {
    readonly color: Color4;
    /** Note: The stroke `width` is twice the stroke radius. */
    readonly width: number;
}
export interface RenderingStyle {
    readonly fill: Color4;
    readonly stroke?: StrokeStyle;
}
export default RenderingStyle;
export declare const cloneStyle: (style: RenderingStyle) => {
    fill: Color4;
    stroke: {
        color: Color4;
        width: number;
    } | undefined;
};
export declare const stylesEqual: (a: RenderingStyle, b: RenderingStyle) => boolean;
export declare const styleToJSON: (style: RenderingStyle) => {
    fill: string;
    stroke: {
        color: string;
        width: number;
    } | undefined;
};
export declare const styleFromJSON: (json: Record<string, any>) => {
    fill: Color4;
    stroke: {
        color: Color4;
        width: any;
    } | undefined;
};
