import  { defaultEditorLocalization }  from '../localization.mjs';
// German localization
const localization = {
    ...defaultEditorLocalization,
    help: 'Hilfe',
    helpHidden: 'Hilfe ausgeblendet',
    next: 'Weiter',
    previous: 'Zurück',
    close: 'Schließen',
    helpScreenNavigationHelp: 'Auf ein Steuerelement klicken, um weitere Informationen zu erhalten.',
    helpControlsAccessibilityLabel: 'Steuerelemente: Aktiviere ein Steuerelement, um Hilfe anzuzeigen.',
    pen: 'Stift',
    eraser: 'Radierer',
    select: 'Auswahl',
    handTool: 'Verschieben',
    zoom: 'Vergrößerung',
    image: 'Bild',
    reformatSelection: 'Formatauswahl',
    inputAltText: 'Alt-Text:',
    decreaseImageSize: 'Verkleinern',
    resetImage: 'Zurücksetzen',
    chooseFile: 'Datei wählen',
    dragAndDropHereOrBrowse: 'Hierher ziehen\noder\n{{Durchsuchen}}',
    submit: 'Absenden',
    addAll: 'Alle hinzufügen',
    cancel: 'Abbrechen',
    resetView: 'Ansicht zurücksetzen',
    thicknessLabel: 'Dicke:',
    colorLabel: 'Farbe:',
    fontLabel: 'Schriftart:',
    textSize: 'Größe:',
    resizeImageToSelection: 'Bildgröße an Auswahl anpassen',
    deleteSelection: 'Auswahl löschen',
    duplicateSelection: 'Auswahl duplizieren',
    exit: 'Beenden',
    save: 'Speichern',
    undo: 'Rückgängig',
    redo: 'Wiederholen',
    fullStrokeEraser: 'Vollständiger Radierer',
    selectPenType: 'Stiftstil:',
    selectShape: 'Form',
    pickColorFromScreen: 'Farbe von Bildschirm auswählen',
    clickToPickColorAnnouncement: 'Klicke auf den Bildschirm, um eine Farbe auszuwählen',
    colorSelectionCanceledAnnouncement: 'Farbauswahl abgebrochen',
    selectionTool__lassoSelect: 'Freihand-Auswahl',
    selectionTool__lassoSelect__help: 'Wenn diese Option aktiviert ist, wird durch Ziehen eine Freiformauswahl (Lasso) erstellt.',
    selectionToolKeyboardShortcuts: 'Auswahl-Werkzeug: Verwende die Pfeiltasten, um ausgewählte Elemente zu verschieben, und die Kleinbuchstaben/Großbuchstaben „i“ und „o“, um die Größe zu ändern.',
    documentProperties: 'Seite',
    backgroundColor: 'Hintergrundfarbe:',
    imageWidthOption: 'Breite:',
    imageHeightOption: 'Höhe:',
    useGridOption: 'Gitter:',
    enableAutoresizeOption: 'Automatische Größenanpassung',
    toggleOverflow: 'Mehr',
    about: 'Über',
    inputStabilization: 'Stabilisierung',
    strokeAutocorrect: 'Autokorrektur',
    pressureSensitivity: 'Druck',
    touchPanning: 'Mit Touch verschieben',
    roundedTipPen: 'Rund',
    roundedTipPen2: 'Polylinie',
    flatTipPen: 'Flach',
    arrowPen: 'Pfeil',
    linePen: 'Linie',
    outlinedRectanglePen: 'Umrandetes Rechteck',
    filledRectanglePen: 'Ausgefülltes Rechteck',
    outlinedCirclePen: 'Umrandeter Kreis.',
    lockRotation: 'Drehung sperren',
    paste: 'Einfügen',
    errorImageHasZeroSize: 'Fehler: Bild hat Größe Null',
    describeTheImage: 'Bildbeschreibung',
    fileInput__loading: 'Lade...',
    fileInput__andNMoreFiles: (n) => `(...${n} mehr)`,
    penDropdown__baseHelpText: 'Dieses Werkzeug zeichnet Formen oder Freihandlinien.',
    penDropdown__colorHelpText: 'Ändert die Farbe des Stifts',
    penDropdown__thicknessHelpText: 'Ändert die Strichstärke des mit dem Stift gezeichneten Strichs.',
    penDropdown__penTypeHelpText: 'Ändert den Stiftstil.\n\nEs kann entweder ein „Stiftstil“ oder eine „Form“ ausgewählt werden. Bei Auswahl eines „Stiftstils“ werden Freihandlinien gezeichnet. Bei Auswahl einer „Form“ werden Formen gezeichnet.',
    penDropdown__autocorrectHelpText: 'Wandelt grobe Freihandlinien und Rechtecke in perfekte Linien und Rechtecke um.\n\nDer Stift muss am Ende eines Strichs still gehalten werden, um eine Korrektur auszulösen.',
    penDropdown__stabilizationHelpText: 'Zeichnet glattere Striche.\n\nDadurch entsteht auch eine kurze Verzögerung zwischen Maus/Stift und Strich.',
    penDropdown__pressureSensitivityHelpText: 'Ändert die Strichstärke entsprechend der Druckstärke, wenn du ein kompatibles Gerät wie einen Stylus verwendest.',
    handDropdown__baseHelpText: 'Dieses Werkzeug ist für das Scrollen, Drehen und Zoomen im Editor zuständig.',
    handDropdown__zoomInHelpText: 'Vergrößert',
    handDropdown__zoomOutHelpText: 'Verkleinert',
    handDropdown__resetViewHelpText: 'Setzt den Zoomfaktor auf 100 % zurück und setzt den Bildlauf zurück.',
    handDropdown__zoomDisplayHelpText: 'Zeigt den aktuellen Zoomfaktor an. 100 % zeigt das Bild in seiner tatsächlichen Größe an.',
    handDropdown__touchPanningHelpText: 'Wenn aktiviert, verschieben Touchscreen-Gesten das Bild, anstatt es auszuwählen oder zu zeichnen.',
    handDropdown__lockRotationHelpText: 'Wenn aktiviert, verhindert diese Option, dass Touch-Gesten den Bildschirm drehen.',
    eraserDropdown__baseHelpText: 'Dieses Werkzeug entfernt Striche, Bilder und Text unter dem Cursor.',
    eraserDropdown__thicknessHelpText: 'Ändert die Größe des Radierers.',
    eraserDropdown__fullStrokeEraserHelpText: 'Im vollständigen Modus werden ganze Formen gelöscht.\n\nAußerhalb des vollständigen Modus können Formen teilweise gelöscht werden.',
    selectionDropdown__baseHelpText: 'Wählt Inhalte aus und bearbeitet die Auswahl',
    selectionDropdown__resizeToHelpText: 'Schneidet die Zeichnung auf die Größe der aktuell ausgewählten Fläche zu.\n\nWenn die automatische Größenanpassung aktiviert ist, wird sie deaktiviert.',
    selectionDropdown__deleteHelpText: 'Löscht ausgewählte Elemente.',
    selectionDropdown__duplicateHelpText: 'Erstellt eine Kopie der ausgewählten Elemente.',
    selectionDropdown__changeColorHelpText: 'Ändert die Farbe ausgewählter Elemente.',
    pageDropdown__baseHelpText: 'Steuert die Hintergrundfarbe, das Muster und die Größe der Zeichenfläche.',
    pageDropdown__backgroundColorHelpText: 'Ändert die Hintergrundfarbe der Zeichenfläche.',
    pageDropdown__gridCheckboxHelpText: 'Aktiviert/deaktiviert ein Hintergrundraster',
    pageDropdown__autoresizeCheckboxHelpText: 'Wenn aktiviert, wird die Seite an die Zeichnung angepasst.\n\nWenn deaktiviert, ist die Seite sichtbar und ihre Größe kann manuell festgelegt werden.',
    pageDropdown__aboutButtonHelpText: 'Zeigt Version, Debugging und andere Informationen an.',
    colorPickerPipetteHelpText: 'Wählt eine Farbe vom Bildschirm aus.',
    colorPickerToggleHelpText: 'Öffnet/schließt den Farbwähler.',
    closeSidebar: (toolName) => `Sidebar für ${toolName} schließen`,
    dropdownShown: (toolName) => `Dropdown-Menü für ${toolName} angezeigt`,
    dropdownHidden: (toolName) => `Dropdown-Menü für ${toolName} versteckt`,
    zoomLevel: (zoomPercent) => `Vergößerung: ${zoomPercent}%`,
    colorChangedAnnouncement: (color) => `Farbe zu ${color} geändert`,
    imageSize: (size, units) => `Bild-Größe: ${size} ${units}`,
    imageLoadError: (message) => `Fehler beim Laden des Bildes: ${message}`,
    penTool: (penNumber) => `Stift ${penNumber}`,
    selectionTool: 'Auswahl',
    selectAllTool: 'Alle auswählen',
    eraserTool: 'Radierer',
    touchPanTool: 'Ansicht mit Touchscreen verschieben',
    twoFingerPanZoomTool: 'Ansicht verschieben und vergrößern',
    undoRedoTool: 'Rückgängig/Wiederholen',
    rightClickDragPanTool: 'Rechtsklick-Ziehen',
    pipetteTool: 'Farbe von Bildschirm auswählen',
    keyboardPanZoom: 'Tastaturkürzel zum Verschieben/Vergrößern der Ansicht',
    selectionMenu__show: 'Auswahlmenü anzeigen',
    selectionMenu__copyToClipboard: 'In Zwischenablage kopieren',
    selectionMenu__duplicate: 'Duplizieren',
    selectionMenu__delete: 'Löschen',
    selectionMenu__paste: 'Einfügen',
    copyPasteError__heading: 'Kopieren/Einfügen',
    copyPasteError__description: 'Ein Fehler ist aufgetreten – dieses Tool hat möglicherweise keinen Zugriff auf die Zwischenablage.',
    copyPasteError__errorDetails: 'Fehler anzeigen',
    copyPasteError__pasteRetry: 'Um es erneut zu versuchen, füge bitte den Text in das Eingabefeld unten ein:',
    copyPasteError__copyMe: 'Kopiere mich!',
    autocorrectedTo: (strokeDescription) => `Automatisch korrigiert zu ${strokeDescription}`,
    autocorrectionCanceled: 'Autokorrektur abgebrochen',
    enterTextToInsert: 'Einzufügender Text',
    changeTool: 'Werkzeug wechseln',
    pasteHandler: 'Kopieren-Einfügen-Handler',
    soundExplorer: 'Klangbasierte Bilderkundung',
    disableAccessibilityExploreTool: 'Klangbasierte Erkundung deaktivieren',
    enableAccessibilityExploreTool: 'Klangbasierte Erkundung aktivieren',
    soundExplorerUsageAnnouncement: 'Soundbasierte Bilduntersuchung aktiviert: Klicke/ziehe den Bildschirm, um eine akustische Darstellung verschiedener Bildbereiche abzuspielen.',
    findLabel: 'Suchen',
    toNextMatch: 'Weiter',
    closeDialog: 'Schließen',
    findDialogShown: 'Suchen-Dialog angezeigt',
    findDialogHidden: 'Suchen-Dialog versteckt',
    focusedFoundText: (matchIdx, totalMatches) => `Sieh Treffer ${matchIdx} von ${totalMatches} an`,
    anyDevicePanning: 'Ansicht mit jedem Eingabegerät verschieben',
    copied: (count) => `Copied ${count} item(s)`,
    pasted: (count) => `Pasted ${count} item(s)`,
    toolEnabledAnnouncement: (toolName) => `${toolName} aktiviert`,
    toolDisabledAnnouncement: (toolName) => `${toolName} deaktiviert`,
    updatedViewport: 'Transformierte Ansicht',
    transformedElements: (elemCount, action) => `${elemCount} Element${1 === elemCount ? '' : 'e'} transformiert (${action})`,
    resizeOutputCommand: (newSize) => `Bildgröße auf ${newSize.w}x${newSize.h} geändert`,
    enabledAutoresizeOutputCommand: 'Automatische Größenanpassung der Ausgabe aktiviert',
    disabledAutoresizeOutputCommand: 'Automatische Größenanpassung der Ausgabe deaktiviert',
    addComponentAction: (componentDescription) => `${componentDescription} hinzugefügt`,
    eraseAction: (elemDescription, countErased) => `${countErased} ${elemDescription} gelöscht`,
    duplicateAction: (elemDescription, countErased) => `${countErased} ${elemDescription} dupliziert`,
    unionOf: (actionDescription, actionCount) => `Vereinigung: ${actionCount} ${actionDescription}`,
    inverseOf: (actionDescription) => `${actionDescription} umgekehrt`,
    elements: 'Elemente',
    erasedNoElements: 'Nichts entfernt',
    duplicatedNoElements: 'Nichts dupliziert',
    rotatedBy: (degrees) => `${Math.abs(degrees)} Grad ${degrees < 0 ? 'im Uhrzeigersinn' : 'gegen den Uhrzeigersinn'} gedreht`,
    movedLeft: 'Nach links bewegt',
    movedUp: 'Nach oben bewegt',
    movedDown: 'Nach unten bewegt',
    movedRight: 'Nach rechts bewegt',
    zoomedOut: 'Ansicht verkleinert',
    zoomedIn: 'Ansicht vergrößert',
    andNMoreCommands: (count) => `Und noch ${count} weitere Befehle.`,
    selectedElements: (count) => `${count} Element${1 === count ? '' : 'e'} ausgewählt`,
    unlabeledImageNode: 'Bild ohne Label',
    stroke: 'Strich',
    svgObject: 'SVG-Objekt',
    emptyBackground: 'Leerer Hintergrund',
    gridBackground: 'Hintergrundraster',
    filledBackgroundWithColor: (color) => `Gefüllter Hintergrund (${color})`,
    text: (text) => `Text-Objekt: ${text}`,
    imageNode: (label) => `Bild: ${label}`,
    restyledElement: (elementDescription) => `${elementDescription} umgestaltet`,
    pathNodeCount: (count) => `Es gibt ${count} sichtbare Pfad-Objekte.`,
    textNodeCount: (count) => `Es gibt ${count} sichtbare Text-Knotenpunkte.`,
    imageNodeCount: (nodeCount) => `Es gibt ${nodeCount} sichtbare Bild-Knoten.`,
    textNode: (content) => `Text: ${content}`,
    rerenderAsText: 'Als Text darstellen',
    accessibilityInputInstructions: 'Drücke ‚t‘, um den Inhalt des Ansichtsfensters als Text zu lesen. Verwende die Pfeiltasten, um die Ansicht zu verschieben, und klicke und ziehe, um Striche zu zeichnen. Drücke ‚w‘ zum Vergrößern und ‚s‘ zum Verkleinern der Ansicht.',
    loading: (percentage) => `${percentage}% geladen...`,
    imageEditor: 'Bild-Editor',
    doneLoading: 'Fertig geladen',
    undoAnnouncement: (commandDescription) => `${commandDescription} rückgängig gemacht`,
    redoAnnouncement: (commandDescription) => `${commandDescription} wiederholt`,
    softwareLibraries: 'Bibliotheken',
    developerInformation: 'Enwicklerinformation',
};
export default localization;
