import  { defaultCommandLocalization }  from './commands/localization.mjs';
import  { defaultComponentLocalization, }  from './components/localization.mjs';
import  { defaultTextRendererLocalization, }  from './rendering/localization.mjs';
import  { defaultToolbarLocalization }  from './toolbar/localization.mjs';
import  { defaultToolLocalization }  from './tools/localization.mjs';
export const defaultEditorLocalization = {
    ...defaultToolbarLocalization,
    ...defaultToolLocalization,
    ...defaultCommandLocalization,
    ...defaultComponentLocalization,
    ...defaultTextRendererLocalization,
    accessibilityInputInstructions: [
        'Press "t" to read the contents of the viewport as text.',
        'Use the arrow keys to move the viewport, click and drag to draw strokes.',
        'Press "w" to zoom in and "s" to zoom out.',
    ].join(' '),
    loading: (percentage) => `Loading ${percentage}%...`,
    imageEditor: 'Image Editor',
    doneLoading: 'Done loading',
    undoAnnouncement: (commandDescription) => `Undid ${commandDescription}`,
    redoAnnouncement: (commandDescription) => `Redid ${commandDescription}`,
    softwareLibraries: 'Libraries',
    developerInformation: 'Developer information',
};
