/**
 * The main entrypoint for the NPM package. Everything exported by this file
 * is available through the [`js-draw` package](https://www.npmjs.com/package/js-draw).
 *
 * ## Example
 *
 * [[include:doc-pages/inline-examples/main-js-draw-example.md]]
 *
 * @see
 * - {@link Editor}
 * - {@link Editor.loadFromSVG}
 * - {@link AbstractToolbar.addActionButton }
 * - {@link EditorSettings}
 *
 * @packageDocumentation
 */
import  Editor  from './Editor.mjs';
export  *  from './image/lib.mjs';
export  *  from './types.mjs';
export  *  from './inputEvents.mjs';
export  { default as getLocalizationTable, matchingLocalizationTable, }  from './localizations/getLocalizationTable.mjs';
export  *  from './localization.mjs';
export  { default as SVGLoader }  from './SVGLoader/SVGLoader.mjs';
export  { default as Viewport }  from './Viewport.mjs';
export * from '@js-draw/math';
export  *  from './components/lib.mjs';
export  *  from './commands/lib.mjs';
export  *  from './tools/lib.mjs';
export  *  from './toolbar/lib.mjs';
export  *  from './rendering/lib.mjs';
export  *  from './testing/lib.mjs';
export  *  from './shortcuts/lib.mjs';
export  { default as EventDispatcher }  from './EventDispatcher.mjs';
export  { default as Pointer, PointerDevice }  from './Pointer.mjs';
export  { default as UndoRedoHistory }  from './UndoRedoHistory.mjs';
export  *  from './util/lib.mjs';
// @internal
export  { default as __js_draw__version }  from './version.mjs';
import  AbstractToolbar  from './toolbar/AbstractToolbar.mjs';
export { Editor, AbstractToolbar };
/**
 * Using the HTMLToolbar alias is deprecated. Use
 * `AbstractToolbar` instead.
 * @deprecated
 */
export { AbstractToolbar as HTMLToolbar };
export default Editor;
