const makeSnapToGridAutocorrect = (sourceFactory) => {
    return (startPoint, viewport) => {
        return new SnapToGridAutocompleteBuilder(sourceFactory, startPoint, viewport);
    };
};
export default makeSnapToGridAutocorrect;
class SnapToGridAutocompleteBuilder {
    constructor(sourceFactory, startPoint, viewport) {
        this.sourceFactory = sourceFactory;
        this.startPoint = startPoint;
        this.viewport = viewport;
        this.builder = sourceFactory(startPoint, viewport);
        this.points = [startPoint];
        if (this.builder.inkTrailStyle) {
            this.inkTrailStyle = this.builder.inkTrailStyle.bind(this.builder);
        }
    }
    getBBox() {
        return this.builder.getBBox();
    }
    build() {
        return this.builder.build();
    }
    preview(renderer) {
        this.builder.preview(renderer);
    }
    addPoint(point) {
        this.points.push(point);
        this.builder.addPoint(point);
    }
    async autocorrectShape() {
        const snapToGrid = (point) => {
            return {
                ...point,
                pos: this.viewport.snapToGrid(point.pos),
            };
        };
        // Use screen points so that snapped shapes rotate with the screen.
        const startPoint = snapToGrid(this.startPoint);
        const builder = this.sourceFactory(startPoint, this.viewport);
        const points = this.points.map((point) => snapToGrid(point));
        for (const point of points) {
            builder.addPoint(point);
        }
        return builder.build();
    }
}
