import AbstractRenderer from '../../rendering/renderers/AbstractRenderer';
import RenderablePathSpec from '../../rendering/RenderablePathSpec';
import { Rect2, Color4 } from '@js-draw/math';
import Stroke from '../Stroke';
import Viewport from '../../Viewport';
import { StrokeDataPoint } from '../../types';
import { ComponentBuilder, ComponentBuilderFactory } from './types';
import RenderingStyle from '../../rendering/RenderingStyle';
/**
 * Creates a freehand line builder that creates strokes from line segments
 * rather than Bézier curves.
 *
 * Example:
 * [[include:doc-pages/inline-examples/changing-pen-types.md]]
 */
export declare const makePolylineBuilder: ComponentBuilderFactory;
export default class PolylineBuilder implements ComponentBuilder {
    private minFitAllowed;
    private viewport;
    private parts;
    private bbox;
    private averageWidth;
    private widthAverageNumSamples;
    private lastPoint;
    private startPoint;
    private lastLineSegment;
    constructor(startPoint: StrokeDataPoint, minFitAllowed: number, viewport: Viewport);
    getBBox(): Rect2;
    protected getRenderingStyle(): RenderingStyle;
    inkTrailStyle(): {
        color: Color4;
        width: number;
    };
    protected previewCurrentPath(): RenderablePathSpec;
    protected previewFullPath(): RenderablePathSpec[];
    preview(renderer: AbstractRenderer): void;
    build(): Stroke;
    private getMinFit;
    private roundPoint;
    private roundDistance;
    addPoint(newPoint: StrokeDataPoint): void;
}
